﻿<%@ Page Language="c#" CodeBehind="SpecyfikacjeSkladnikiSzczegoly.aspx.cs" AutoEventWireup="True" Inherits="KOLKaP_WEB.KOLKaP.SpecyfikacjeSkladnikiSzczegoly" %>

<html>
<head>
    <title>KOLKaP Kadry Płace</title>
    <meta http-equiv="pragma" content="no-cache" />
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />

    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>

    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>

    <script type="text/javascript" language="javascript" src="../Skrypty.js"></script>

    <script language="javascript" type="text/javascript">
        $(function () {

            $("#btnZapisz").button({ icons: { primary: 'ui-icon-disk' } });
        });
    </script>
</head>
<body class="Table" oncontextmenu="return false">
    <form id="frmKOLKaPSpecyfikacjeSzczegoly" method="post" runat="server">
        <table class="Table" style="height: 100%; width: 100%" cellspacing="2" cellpadding="2" border="0">
            <tr valign="top">
                <td colspan="5" style="height: 20">
                    <span style="font-size: 16; font-weight: bold">
                        <asp:Label ID="lbTitle" runat="server">Składnik specyfikacji</asp:Label>
                        <asp:TextBox ID="tbIdSpecyfikacji" runat="server" Text='<%# DataBinder.Eval(dsSpecyfikacje, "Tables[SPECYFIKACJE_SKLADNIKI_LIST].DefaultView.[0].ID_SPECYFIKACJI") %>'
                            Width="96px" Height="10px" Visible="False">
                        </asp:TextBox>
                    </span>
                </td>
            </tr>

            <tr valign="top">
                <td valign="bottom" colspan="5" style="height: 30">
                    <small>Rodzaj składnika:</small><br />
                    <asp:DropDownList ID="ddlSkladnik" runat="server" AutoPostBack="True" DataValueField="ID_SKLADNIKA"
                        DataTextField="NAZWA" DataMember="S_SKLADNIKOW_FAKTURY_LIST" DataSource="<%# dsSpecyfikacje %>"
                        Width="100%" OnSelectedIndexChanged="ddlSkladnik_SelectedIndexChanged">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr valign="top">
                <td valign="bottom" colspan="5" style="height: 30">
                    <small>Kwota:</small><br />
                    <asp:TextBox ID="tbKwota" runat="server" Width="100%" Text='<%# DataBinder.Eval(dsSpecyfikacje, "Tables[SPECYFIKACJE_SKLADNIKI_LIST].DefaultView.[0].KWOTA") %>'
                        CssClass="aspTextbox">
                    </asp:TextBox>
                </td>
            </tr>
            <tr valign="top">
                <td valign="bottom" colspan="5" style="height: 30">
                    <small>Opis:</small><br />
                    <asp:TextBox ID="tbOpis" runat="server" Width="100%" Text='<%# DataBinder.Eval(dsSpecyfikacje, "Tables[SPECYFIKACJE_SKLADNIKI_LIST].DefaultView.[0].OPIS") %>'
                        CssClass="aspTextbox">
                    </asp:TextBox>
                </td>
            </tr>
            <tr valign="top">
                <td valign="bottom" colspan="5" style="height: 30">
                    <asp:CheckBox ID="cbKosztyDodatkowe" runat="server" Text="Koszty dodatkowe"></asp:CheckBox>
                </td>
            </tr>
            <tr>
                <td valign="middle" colspan="5" style="height: 20">
                    <asp:Label ID="lblError" runat="server"></asp:Label>
                </td>
            </tr>
            <tr valign="top">
                <td valign="bottom" colspan="3" style="height: 30">
                    <!--<asp:hyperlink id="hlPowrot" runat="server" Target="KOLKaP" NavigateUrl="Specyfikacje.aspx?OPERACJA=EDYTUJ">&lt;&lt;&lt; Powrót</asp:hyperlink>-->
                    <asp:LinkButton ID="lbPowrot" runat="server" OnClick="lbPowrot_Click">&lt;&lt;&lt; Powrót</asp:LinkButton>
                </td>
                <td valign="bottom" align="right" colspan="2" style="height: 30">
                    <asp:LinkButton ID="btnZapisz" runat="server" CssClass="aspButton" Text="Zapisz" OnClick="btnZapisz_Click" Style="display: none; width: 90px;">
                    </asp:LinkButton>
                </td>
            </tr>
            <tr>
                <td colspan="5"></td>
            </tr>
        </table>
    </form>
</body>
</html>
